/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;

public class ScheduleInputCardVo extends ScheduleMenuVo {

	private static final long serialVersionUID = 7506588503963452011L;

	//URLACSS
	private static final String RETURN_URL	= "/jsp/kintai/scheduleInputCard.jsp";
	private static final String EXTRA_JS		= "/pub/kintai/js/scheduleInputCard.js";
	private static final String EXTRA_CSS		= "/pub/kintai/css/scheduleInputCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_SCHEDULE_INPUT;

	//萔
	public static final int MODE_INSERT = 0;

	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
	// p[^
//	public static final String PRM_PLT_SCHEDULE_YEAR		= "pltScheduleYear"	;
//	public static final String PRM_PLT_SCHEDULE_MONTH		= "pltScheduleMonth";
	public static final String PRM_PLT_SCHEDULE_DAY		= "pltScheduleDay"	;
	public static final String PRM_PLT_ROTATION_CODE		= "pltRotationCode"	;
	public static final String PRM_PLT_ROTATION_DAYS		= "pltRotationDays"	;

	public static final String PRM_PLT_WORK_TYPE_CODE		= "pltWorkTypeCode"	;
	public static final String PRM_CKB_SELECT_WORK_TYPE	= "ckbSelectWorkType";
	public static final String PRM_CKB_SELECT_PERIOD		= "ckbSelectPeriod";

	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
	// tB[hyѐ
//	public static final String NAM_SCHEDULE_START		= CommonConst.NAM_SCHEDULE_START_DATE;
//	public static final String NAM_ROTATION_TYPE		= CommonConst.NAM_ROTATION_TYPE;
	public static final String NAM_SCHEDULE_START		= CommonConst.NAM_TARGET_MONTH;
	public static final String NAM_ROTATION_TYPE		= CommonConst.NAM_WORKING_TYPE;
	public static final String NAM_ROTATION_DAYS		= CommonConst.NAM_NUMBER_OF_DAYS;

	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
	// tB[h
//	private String pltScheduleYear;
//	private String pltScheduleMonth;
	private String pltScheduleDay;
	private String pltRotationCode;
	private String pltRotationDays;

	private String pltWorkTypeCode;
	private String ckbSelectWorkType;
	private String ckbSelectPeriod;

	// v_EXg
	public String[][] aryPltScheduleYear;
	public String[][] aryPltScheduleMonth;
	public String[][] aryPltScheduleDay;
	public String[][] aryPltRotation;
	public String[][] aryPltDays;

	public String[][] aryPltWorkType;

	// ҏW[h(0Fo^)
	private int mode;	

	/**
	 * RXgN^
	 */		
	public ScheduleInputCardVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		mode = MODE_INSERT;
		initFields();
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		super.setParams(request);
//		pltScheduleYear 	= request.getParameter(PRM_PLT_SCHEDULE_YEAR);
//		pltScheduleMonth 	= request.getParameter(PRM_PLT_SCHEDULE_MONTH);
		pltScheduleDay 		= request.getParameter(PRM_PLT_SCHEDULE_DAY);
		pltRotationCode 	= request.getParameter(PRM_PLT_ROTATION_CODE);
		pltRotationDays 	= request.getParameter(PRM_PLT_ROTATION_DAYS);

		pltWorkTypeCode		= request.getParameter(PRM_PLT_WORK_TYPE_CODE);
		ckbSelectWorkType 	= getCheckBoxParam(request.getParameter(PRM_CKB_SELECT_WORK_TYPE));
		ckbSelectPeriod 	= getCheckBoxParam(request.getParameter(PRM_CKB_SELECT_PERIOD));
	}

	/**
	 * tB[h
	 */
	public void initFields() {
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
//		pltScheduleYear 	= "";
//		pltScheduleMonth 	= "";
		pltScheduleDay 		= "";
		pltRotationCode 	= "";
		pltRotationDays 	= "";
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		// t`FbN
		/*		
		checkDate(
				Integer.parseInt(pltScheduleYear),
				Integer.parseInt(pltScheduleMonth),
				Integer.parseInt(pltScheduleDay),
				NAM_SCHEDULE_START, PRM_PLT_SCHEDULE_YEAR
		);
		 */		
		if (ckbSelectPeriod.equals(CommonConst.NAM_DEFAULT_FLAG_ON)) {
			checkDate(getIntParam(getPltYear()), getIntParam(getPltMonth()), getIntParam(pltScheduleDay),
					NAM_SCHEDULE_START, PRM_PLT_SCHEDULE_DAY);
		}
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	//public String[][] getAryPltRotation() { return aryPltRotation; }
	public String[][] getAryPltRotation() { return aryPltRotation.clone(); }

	public String getPltRotationCode() 	{ return pltRotationCode	; }
	public String getPltRotationDays() 	{ return pltRotationDays	; }
	public String getPltScheduleDay() 	{ return pltScheduleDay		; }
	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
//	public String getPltScheduleMonth()	{ return pltScheduleMonth	; }
//	public String getPltScheduleYear() 	{ return pltScheduleYear	; }

	public void setPltRotationCode	(String pltRotationCode	) 	{ this.pltRotationCode 	= pltRotationCode	; }
	public void setPltRotationDays	(String pltRotationDays	) 	{ this.pltRotationDays 	= pltRotationDays	; }
	public void setPltScheduleDay	(String pltScheduleDay	) 	{ this.pltScheduleDay 	= pltScheduleDay	; }
	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
//	public void setPltScheduleMonth(String pltScheduleMonth)	{ this.pltScheduleMonth	= pltScheduleMonth	; }
//	public void setPltScheduleYear	(String pltScheduleYear	) 	{ this.pltScheduleYear 	= pltScheduleYear	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() {return mode; }

	/*						
	 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
	 */
	public String getCkbSelectWorkType() { return ckbSelectWorkType; }
	public String getEscCkbSelectWorkType() { return getCheckBoxChecked(ckbSelectWorkType); }
	public void setCkbSelectWorkType(String ckbSelectWorkType) { this.ckbSelectWorkType = ckbSelectWorkType; }

	public String getCkbSelectPeriod() { return ckbSelectPeriod; }
	public String getEscCkbSelectPeriod() { return getCheckBoxChecked(ckbSelectPeriod); }
	public void setCkbSelectPeriod(String ckbSelectPeriod) { this.ckbSelectPeriod = ckbSelectPeriod; }

	public String getPltWorkTypeCode() { return pltWorkTypeCode; }
	public void setPltWorkTypeCode(String pltWorkTypeCode) { this.pltWorkTypeCode = pltWorkTypeCode; }

}
